<?php
/**
 * Created by PhpStorm.
 * User: brandon
 * Date: 1/13/15
 * Time: 3:11 PM
 */

namespace Lyralux\Bundle\PDFBundle\Wrapper;

use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
//use Lyralux\Bundle\PDFBundle\Wrapper\PDFGenerator;
use mikehaertl\pdftk\Pdf as FillPdf;


use ZendPdf\PdfDocument;
use ZendPdf\Page;
use ZendPdf\Font;
use ZendPdf\Style;
use ZendPdf;

require_once dirname(__FILE__).'/../mPDF/mpdf.php';

class PDF {

	protected $container;

	protected $pdf;

	protected $options = array('utf-8', 'Letter', 10, '', 15, 15, 25, 16, 11, 9);

	public function __construct(Container $container)
	{
		$this->container = $container;
		$this->pdf = new \mPDF('utf-8', 'Letter', 10, '', 17.145, 17.145, 54, 17.145);
	}

	public function addPageWithTemplate($filename, $html)
	{

		$this->pdf->SetImportUse();
		$pageCount = $this->pdf->SetSourceFile($this->getFile($filename));
		$tplIdx = $this->pdf->ImportPage($pageCount);


		// add a page
		//$this->pdf->setFooterTpl($this->getFile('@LyraluxPDFBundle/Resources/public/pdf/footer-01.svg'));
		$this->pdf->AddPage();
		$this->pdf->UseTemplate($tplIdx);
		// now write some text above the imported page
		$this->pdf->WriteHTML($html);
	}

	public function addPageWithBarcode($html) {

		$this->pdf = new \mPDF('utf-8', [ 58.7375, 101.6], '', '', 0, 0, 0, 0, 0, 0, 'P');
		// now write some text above the imported page
		$this->pdf->WriteHTML( $html );
	}

	public function addPageWithBarcodeTest( $html ) {

		$this->pdf = new \mPDF( 'utf-8', [ 58.7375, 101.6 ], '', '', 1.76, 1.76, 1.76, 1.76, 0, 0, 'L' );
		// now write some text above the imported page
		$this->pdf->WriteHTML( $html );
	}

	public function addPage($html)
	{
		$this->pdf->AddPage();
		$this->pdf->WriteHTML($html);

	}

	public function getPdf($fileName)
	{
		$this->pdf->Output($fileName, 'I');
	}

	protected function getFile($filename)
	{
		$kernel = $this->container->get('kernel');

		return $kernel->locateResource($filename);

	}

	public function fillPdf($fileName, $data, $output)
	{


		$file = $this->getFile($fileName);

		$pdf1 = PdfDocument::load($file);
		// Reverse page order
		$pdf1->pages = array_reverse($pdf1->pages);
		//$pdf1->load($file);
		$tplIdx = $pdf1->pages[0];

		$pdf1->pages[] = ($page1 = new Page($tplIdx));
		$page2 = new Page(Page::SIZE_LETTER_LANDSCAPE);
		$pdf1->pages[] = $page2;
		// Create new font
		$font = Font::fontWithName(Font::FONT_HELVETICA);

		// Apply font and draw text
		$page1->setFont($font, 36)
			->setFillColor(ZendPdf\Color\Html::color('#9999cc'))
			->drawText('Helvetica 36 text string', 60, 500);

		// Use font object for another page
		$page2->setFont($font, 24)
			->drawText('Helvetica 24 text string', 60, 500);

		return $pdf1->render();

		$path = __DIR__ . '/../../../../../../web/uploads/pdf';
		$filePath = $path . '/' . $output;

//		$pdf = new FillPdf();
//		$pdf->addFile($file);
//		$pdf->fillForm($data);
//		$pdf->needAppearances();
//		$pdf->send();

		//$pdf->fillForm($data);
		//return $pdf->getDataFields();


		//return $filePath;

	}

	/**
	 * @param $fileName
	 * @param $info
	 * @param string $enc
	 * @return string
	 */
	public function create_xfdf($fileName, $info, $enc = 'UTF-8')
	{
		$file = $this->getFile($fileName);
		$requestTime = time();
		$data = '<?xml version="1.0" encoding="' . $enc . '"?>' . "\n" .
			'<xfdf xmlns="http://ns.adobe.com/xfdf/" xml:space="preserve">' . "\n" .
			'<fields>' . "\n";
		foreach ($info as $name => $value) {
			$data .= '<field name="' . htmlspecialchars($name) . '"><value>' . htmlspecialchars($value) . '</value></field>' . "\n";
		}
		$data .= '</fields>' . "\n" .
			'<ids original="' . md5($file) . '" modified="' . $requestTime . '" />' . "\n" .
			'<f href="' . $file . '" />' . "\n" .
			'</xfdf>' . "\n";

		return $data;
	}

}