<?php

namespace SoundView\Bundle\CommissionBundle\Form\Type;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections\Collection;

use Symfony\Component\Routing\Router;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

use Oro\Bundle\LocaleBundle\Formatter\NameFormatter;
use Oro\Bundle\SecurityBundle\SecurityFacade;


class CommissionPayType extends AbstractType
{
     /**
     * @var Router
     */
    protected $router;

    /**
     * @var NameFormatter
     */
    protected $nameFormatter;

    /**
     * @var SecurityFacade
     */
    protected $securityFacade;

     /**
     * @param Router $router
     * @param NameFormatter $nameFormatter
     * @param SecurityFacade $securityFacade
     */
    public function __construct(Router $router, NameFormatter $nameFormatter, SecurityFacade $securityFacade)
    {
        $this->nameFormatter  = $nameFormatter;
        $this->router         = $router;
        $this->securityFacade = $securityFacade;

    }
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'paidDate', 'oro_datetime', 
                [
                    'label' => 'Paid Date',
                    'required' => false
                ]
            )
            ->add(
                'amount', 'oro_money', 
                [
                    'required' => false,
                    'label' => 'Amount'
                ]
            )
            ->add(
                'description', 'text', 
                [
                    'label' => 'Description',
                    'required' => false
                ]
            );
            

        //$builder->add(
//            'poNumbers',
//            'sv_po_collection',
//             array(
//                'label'    => '',
//                'type'     => 'sv_po',
//                'required' => false,
//                'options'  => array('data_class' => 'SoundView\Bundle\SaleBundle\Entity\SalePO')
//            )
//        );
    }





    /**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => 'SoundView\Bundle\CommissionBundle\Entity\Commission',
                'intention' => 'commission',
                'cascade_validation' => true,
				'csrf_protection' => false
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_commission_pay';
    }
}
