<?php

namespace SoundView\Bundle\SaleBundle\Controller\Api\Rest;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;

use Nelmio\ApiDocBundle\Annotation\ApiDoc;

use FOS\RestBundle\Controller\Annotations\NamePrefix;
use FOS\RestBundle\Controller\Annotations\RouteResource;
use FOS\RestBundle\Controller\Annotations\QueryParam;
use FOS\RestBundle\Controller\Annotations\Route;
use FOS\RestBundle\Controller\Annotations\Get;
use FOS\RestBundle\Controller\Annotations\Post;
use FOS\RestBundle\Routing\ClassResourceInterface;
use FOS\RestBundle\Controller\Annotations as Rest;
use FOS\RestBundle\Util\Codes;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;
use Oro\Bundle\SoapBundle\Entity\Manager\ApiEntityManager;
use Oro\Bundle\SoapBundle\Form\Handler\ApiFormHandler;
use Oro\Bundle\SoapBundle\Controller\Api\Rest\RestController;

use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;



/**
 * @RouteResource("purchase_order")
 * @NamePrefix("svwd_api_")
 */
class PurchaseOrderController extends RestController implements ClassResourceInterface
{
	
	/**
     * Receive product
     *
     * Returns
     * - HTTP_OK (200)
     * @Rest\Get(
     *      "/po/receive/{id}",
     *      requirements={"version"="latest|v1"},
     *      defaults={"version"="latest", "_format"="json"}
     * )
     * @ApiDoc(description="Receive product", resource=true)
     * @AclAncestor("svwd_so_update")
     *
     * @param PurchaseOrder $purchaseOrder
     * @return Response
     */
    public function receiveAction(PurchaseOrder $purchaseOrder)
    {
        $purchaseOrder->setReceived(true);
		$purchaseOrder->setDeliveredOn(new \DateTime('now'));
		
		
           if($this->get('svwd_sale.purchase_order.form.handler.api')->receive($purchaseOrder)){
                $this->getDoctrine()->getManager()->flush();
				//$this->get('session')->getFlashBag()->add(
//                        'success',
//                        'Product Received'
//                    );
			
			return $this->handleView(
				$this->view(
					array(
						'successful' => true,
						'message' => 'Product Received'
					),
					Codes::HTTP_OK
				)
			);
		   }

    }

    /**
     * REST GET po
     *
     * @param string $saleId
     * @param string $poId
     *
     * @ApiDoc(
     *      description="Get sale po",
     *      resource=true
     * )
     * @AclAncestor("svwd_so_view")
     * @return Response
     */
    public function getAction($saleId, $poId)
    {
        /** @var Contact $contact */
        $sale = $this->getSaleManager()->find($saleId);

        /** @var ContactAddress $address */
        $po = $this->getManager()->find($poId);

        $addressData = null;
        if ($po && $sale->getPurchaseOrders()->contains($po)) {
            $addressData = $this->getPreparedItem($po);
        }
        $responseData = $addressData ? json_encode($addressData) : '';
        return new Response($responseData, $po ? Codes::HTTP_OK : Codes::HTTP_NOT_FOUND);
    }
	
    /**
     * REST GET list
     *
     * @ApiDoc(
     *      description="Get all addresses items",
     *      resource=true
     * )
     * @AclAncestor("svwd_so_view")
     * @param int $saleId
     *
     * @return JsonResponse
     */
    public function cgetAction($saleId)
    {
        /** @var Sale $sale */
        $sale = $this->getSaleManager()->find($saleId);
        $result  = [];

        if (!empty($sale)) {
            $items = $sale->getPurchaseOrders();

            foreach ($items as $item) {
                $result[] = $this->getPreparedItem($item);
            }
        }

        return new JsonResponse(
            $result,
            empty($sale) ? Codes::HTTP_NOT_FOUND : Codes::HTTP_OK
        );
    }


    /**
     * REST PUT
     *
     * @param int $id PurchaseOrder item id
     *
     * @ApiDoc(
     *      description="Update po",
     *      resource=true
     * )
     * @AclAncestor("svwd_sale_po_update")
     * @return Response
     */
    public function putAction($id)
    {
        return $this->handleUpdateRequest($id);
    }

    /**
     * Create new po
     *
     * @ApiDoc(
     *      description="Create new po",
     *      resource=true
     * )
     * @AclAncestor("svwd_sale_po_create")
     */
    public function postAction()
    {
        return $this->handleCreateRequest();
    }

    /**
     * REST DELETE
     *
     * @param int $id
     *
     * @ApiDoc(
     *      description="Delete po",
     *      resource=true
     * )
     * @Acl(
     *      id="sv_sale_po_delete",
     *      type="entity",
     *      permission="DELETE",
     *      class="SoundViewSaleBundle:PurchaseOrder"
     * )
     * @return Response
     */
    public function deleteAction($id)
    {
        return $this->handleDeleteRequest($id);
    }

    /**
     * Get entity Manager
     *
     * @return ApiEntityManager
     */
    public function getManager()
    {
        return $this->get('svwd_sale.purchase_order.manager.api');
    }

    public function getSaleManager()
    {
        return $this->get('svwd_sale.sale.manager.api');
    }

    /**
     * @return FormInterface
     */
    public function getForm()
    {
        return $this->get('svwd_sale.purchase_order.form.api');
    }
	
	public function getFormType()
    {
        return $this->get('svwd_sale.purchase_order.form.type.api');
    }

    /**
     * @return ApiFormHandler
     */
    public function getFormHandler()
    {
        return $this->get('svwd_sale.purchase_order.form.handler.api');
    }

    /**
     * {@inheritdoc}
     */
    protected function transformEntityField($field, &$value)
    {
        switch ($field) {
            case 'owner':
            default:
                parent::transformEntityField($field, $value);
        }
    }

     protected function getPreparedItem($entity, $resultFields = [])
    {


        $result = parent::getPreparedItem($entity);
		
		

        unset($result['owner']);

        return $result;
    }

    /**
     * {@inheritDoc}
     */
    protected function fixFormData(array &$data, $entity)
    {
        parent::fixFormData($data, $entity);

        unset($data['id']);
        unset($data['createdAt']);
        unset($data['updatedAt']);

        return true;
    }
}
