<?php

namespace SoundView\Bundle\SaleBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\UserBundle\Entity\User;
use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;
use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\Payment;


class PaymentController extends Controller
{

	/**
     * @Route(
     *      "/payment.{_format}",
     *      name="svwd_payment_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     * @Acl(
     *      id="svwd_payment_view",
     *      type="entity",
     *      class="SoundViewSaleBundle:Payment",
     *      permission="VIEW"
     * )
     * @Template
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('svwd_sale.payment.class')
        ];
	}
	/**
     * @Route("/payment-list/{id}", name="svwd_sale_payment_list", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function paymentListAction(Sale $sale)
    {
        return array(
            'entity' => $sale,
            'payment_edit_acl_resource' => 'svwd_sale_update'
        );
    }
	
	
   /**
    * @Route(
    *      "/payment-update/{id}",
    *      name="svwd_sale_payment_update",
    *      requirements={"saleId"="\d+","id"="\d+"},defaults={"id"=0},
	*      options={"expose"=true}
    * )
    * @Template
    * @AclAncestor("svwd_sale_update")
    */
   public function updateAction(Payment $payment)
   {
       return $this->update($payment);
   }

       /**
     * @Route("/payment-view/{id}", name="svwd_sale_payment_view", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="svwd_sale_view",
     *      type="entity",
     *      permission="VIEW",
     *      class="SoundViewSaleBundle:Payment"
     * )
     */
    public function viewAction(Payment $payment)
    {
        return [
            'entity' => $payment,
        ];
    }
	
	
	/**
    * @Route(
    *      "/create-payment/{saleId}",
    *      name="svwd_sale_payment_create",
    *      requirements={"saleId"="\d+"},
	  *      options={"expose"=true}
    * )
    * @Acl(
    *      id="svwd_sale_payment_create",
    *      type="entity",
    *      permission="CREATE",
    *      class="SoundViewSaleBundle:Payment"
    * )
    * @Template("SoundViewSaleBundle:Payment:update.html.twig")
    * @ParamConverter("sale", options={"id" = "saleId"})
    */
   public function createAction(Sale $sale)
   {   
        $payment = new Payment();

        $payment->setSalesOrder($sale);

        return $this->update($payment);

   }
	
	/**
    * @param Sale $sale
    * @param Payment $payment
    * @return array
    * @throws BadRequestHttpException
    */
   protected function update(Payment $entity)
   {
	   if (!$entity) {
            $entity = $this->getManager()->createEntity();
        }

        return $this->get('oro_form.model.update_handler')->handleUpdate(
            $entity,
            $this->get('svwd_sale.payment.form'),
            function (Payment $entity) {
                return array(
                    'route' => 'svwd_payment_update',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            function (Sale $entity) {
                return array(
                    'route' => 'svwd_payment_view',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            'Payment Saved',
            $this->get('svwd_sale.payment.form.handler')
        );
   }

    /**
     * @return User
     */
    public function getCurrentUser()
    {
        $token = $this->container->get('security.context')->getToken();

        return $token ? $token->getUser() : null;
    }
	
	
	    /**
     * @return PaymentType
     */
    protected function getFormType()
    {
        return $this->get('svwd_sale.form.type.payment_api');
    }
	
	    /**
     * @param string $entityName
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    protected function getRepository($entityName)
    {
        return $this->getDoctrine()->getRepository($entityName);
    }
	
}
