<?php

namespace SoundView\Bundle\SaleBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Component\DomCrawler\Crawler;
use Symfony\Component\HttpFoundation\File\UploadedFile;

use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

use Oro\Bundle\SecurityBundle\Annotation\Acl;
use Oro\Bundle\SecurityBundle\Annotation\AclAncestor;

use Oro\Bundle\UserBundle\Entity\User;
use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;

use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\Manager\PurchaseOrderManager;

use SoundView\Bundle\SaleBundle\Provider\PurchaseOrderResultProvider;

use Oro\Bundle\SearchBundle\Provider\ResultStatisticsProvider;
use Oro\Bundle\SearchBundle\Event\PrepareResultItemEvent;

use Lyralux\Bundle\PDFBundle\Wrapper\TCPDFWrapper;

use FOS\RestBundle\Util\Codes;

use Oro\Bundle\EmailBundle\Entity\EmailTemplate;


class PurchaseOrderController extends Controller
{

	 /**
     * @Route(
     *      "/po.{_format}",
     *      name="svwd_po_index",
     *      requirements={"_format"="html|json"},
     *      defaults={"_format" = "html"}
     * )
     * @Acl(
     *      id="svwd_po_view",
     *      type="entity",
     *      class="SoundViewSaleBundle:PurchaseOrder",
     *      permission="VIEW"
     * )
     * @Template
     */
    public function indexAction()
    {
        return [
            'entity_class' => $this->container->getParameter('svwd_sale.purchase_order.class')
        ];
	}

	/**
	 * @Route(
	 *      "/po/received/",
	 *      name="svwd_po_received"
	 * )
	 * @Acl(
	 *      id="svwd_po_view",
	 *      type="entity",
	 *      class="SoundViewSaleBundle:PurchaseOrder",
	 *      permission="VIEW"
	 * )
	 * @Template
	 */
	public function receivedAction() {
		$date = new \DateTime();
		$date = $date->format('Y-m-d 00:00:00');


		return [
			'entity_class' => $this->container->getParameter( 'svwd_sale.purchase_order.class' ),
			'deliveryDate' => $date
		];
	}

    /**
     * @Route(
     *      "/view/list/{entityId}",
     *      name="svwd_sale_sale_purchase_orders"
     * )
     *
     * @AclAncestor("svwd_sale_view")
     */
    public function getAction($entityId)
    {

        $sorting = strtoupper($this->getRequest()->get('sorting', 'DESC'));

        $manager = $this->getPurchaseOrderManager();

        $result = $manager->getEntityViewModels(
            $manager->getList($entityId, $sorting)
        );

        return new Response(json_encode($result), Codes::HTTP_OK);
    }
	
    /**
     * @Route("/po-list/{id}", name="svwd_sale_po_list", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function poListAction(Sale $sale)
    {
        return array(
            'entity' => $sale,
            'po_edit_acl_resource' => 'svwd_sale_update'
        );
    }


	/**
	 * @Route("/po-results/{id}", name="svwd_sale_po_results", requirements={"id"="\d+"})
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */
	public function poResultsAction( Sale $sale ) {
		return array(
			'entity'               => $sale,
			'po_edit_acl_resource' => 'svwd_sale_update'
		);
	}
    
    /**
     * @Route("/xml", name="svwd_sale_po_xml")
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function xmlAction()
    {
        $file = NULL;
        $xml = NULL;
        $request = $this->getRequest();
        
        $form = $this->createFormBuilder($file)
                ->add('attachment', 'file', array('label' => 'File'))
                ->getForm();
        
        if($request->isMethod('POST')){
            $form->submit($request);
            if($form->isValid()){
                
                $file = $form['attachment']->getData();

                $contents = file_get_contents($file->getPathname());
                
                $xmlObject = simplexml_load_file($file->getPathname());

                //$crawler = new Crawler();

                //$crawler->addXmlContent($contents);
                
                //$xml = var_dump($crawler);
                $xml = array();
                foreach($xmlObject->Detail->Item as $item){
                    $xml[$item["ID"]] = $item;
                }

                //$crawler->filterXPath('//default:Order/Detail/Item');
                
            }
            //foreach($crawler as $dom){
              //  $xml[$dom->nodeName] = $dom->text();
            //}
             
        }
        
        return array(
            'xml' => $xml, 
            'form' => $form->createView()
        );
        
        
        
        
        
    }
    
    protected function upload()
    {
        
    }
    
    /**
     * @Route("/pickup-form/{id}", name="svwd_po_print_pickup_form", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function pdfPickupFormAction(PurchaseOrder $purchaseOrder)
    {

        $html = $this->renderView('SoundViewSaleBundle:PurchaseOrder:Print/productCheckout.html.twig',  array('entity' => $purchaseOrder));
        $pdf = $this->get('lyralux_pdf');
        $fileName = $purchaseOrder->getPoNumber() . 'CUST_PICKUP_FORM.pdf';
        $pdf->addPageWithTemplate('@LyraluxPDFBundle/Resources/public/pdf/customer_pickup_final.pdf', $html);

        return new Response(
            $pdf->getPdf($fileName),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename="'.$fileName.'"'
            )
        );
    }

	/**
	 * @Route("/barcode-render/{id}", name="svwd_po_barcode_render", requirements={"id"="\d+"})
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */
	public function barcodeRenderAction( PurchaseOrder $purchaseOrder ) {

		$barcode = new TCPDFWrapper();

		return $barcode->renderBarcode();

//		$html     = $this->renderView( 'SoundViewSaleBundle:PurchaseOrder:Print/productCheckout.html.twig', array( 'entity' => $purchaseOrder ) );
//		$pdf      = $this->get( 'lyralux_pdf' );
//		$fileName = $purchaseOrder->getPoNumber() . 'CUST_PICKUP_FORM.pdf';
//		$pdf->addPageWithTemplate( '@LyraluxPDFBundle/Resources/public/pdf/customer_pickup_final.pdf', $html );
//
//		return new Response(
//			$pdf->getPdf( $fileName ),
//			200,
//			array(
//				'Content-Type'        => 'application/pdf',
//				'Content-Disposition' => 'attachment; filename="' . $fileName . '"'
//			)
//		);
	}




	/**
	 * @Route("/print-barcodes/{id}", name="svwd_po_print_barcodes", requirements={"id"="\d+"})
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */
	public function pdfBarcodeAction( PurchaseOrder $purchaseOrder ) {
		$itemCount = 0;
		$i = 1;
		$items = [];
		foreach($purchaseOrder->getItemCounts() as $count){
			$itemCount += $count->getItemCount();
		}

		while($i <= $itemCount){
			$items[] = ['number' => $i, 'po' => $purchaseOrder->getPoNumber()];
			$i++;
		}

		$html     = $this->renderView( 'SoundViewSaleBundle:PurchaseOrder:Print/barcodes.html.twig', array( 'entity' => $purchaseOrder, 'itemCount' => $itemCount, 'items'=> $items ) );
		$pdf      = $this->get( 'lyralux_pdf' );
		$fileName = $purchaseOrder->getPoNumber() . 'BARCODES.pdf';
		$pdf->addPageWithBarcode( $html );

		return new Response(
			$pdf->getPdf( $fileName ),
			200,
			array(
				'Content-Type'        => 'application/pdf',
				'Content-Disposition' => 'attachment; filename="' . $fileName . '"'
			)
		);
	}


	/**
	 * @Route("/test-barcodes/{id}", name="svwd_po_test_barcodes", requirements={"id"="\d+"})
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */
	public function testBarcodeAction( PurchaseOrder $purchaseOrder ) {
		$itemCount = 0;
		$i         = 1;
		$items     = [ ];
		foreach ( $purchaseOrder->getItemCounts() as $count ) {
			$itemCount += $count->getItemCount();
		}
		$itemCountString = str_pad($itemCount, 3, 0, STR_PAD_LEFT);

		while ( $i <= $itemCount ) {
			$items[] = [ 'number' => str_pad($i, 3, 0, STR_PAD_LEFT) , 'po' => $purchaseOrder->getPoNumber() ];
			$i ++;
		}

		$html     = $this->renderView( 'SoundViewSaleBundle:PurchaseOrder:Print/barcodeTest.html.twig', array(
			'entity'    => $purchaseOrder,
			'data' => $purchaseOrder->getLabelData(),
			'itemCount' => $itemCount,
			'items'     => $items,
			'itemCountString' => $itemCountString
		) );

		$pdf      = $this->get( 'lyralux_pdf' );
		$fileName = $purchaseOrder->getPoNumber() . 'BARCODES.pdf';
		$pdf->addPageWithBarcodeTest( $html );

		return new Response(
			$pdf->getPdf( $fileName ),
			200,
			array(
				'Content-Type'        => 'application/pdf',
				'Content-Disposition' => 'attachment; filename="' . $fileName . '"'
			)
		);
	}



	/**
	 * @param Request $request
	 * @return array
	 *
	 * @Route("/receiving/", name="svwd_po_receiving")
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */

	public function receivingAction(Request $request){

		if ( $request->get( 'search' ) ) {

			$from   = 'svwd_purchase_order';
			$string = $request->get( 'search' );

			/** @var $resultProvider ResultStatisticsProvider */
			$resultProvider = $this->get( 'oro_search.provider.result_statistics_provider' );
			$groupedResults = $resultProvider->getGroupedResults( $string );
			$selectedResult = null;

			foreach ( $groupedResults as $alias => $type ) {
				if ( $alias == $from ) {
					$selectedResult = $type;
				}
			}
		} else {
			$from   = 'svwd_purchase_order';
			$string = 'Enter Search Term..';
			$groupedResults = false;
			$selectedResult = false;
		}

		return array(
			'from'           => $from,
			'searchString'   => $string,
			'groupedResults' => $groupedResults,
			'selectedResult' => $selectedResult
		);
//		return [
//			'entity_class' => $this->container->getParameter( 'svwd_sale.purchase_order.class' )
//		];
	}


	/**
	 * @param Request $request
	 *
	 * @return array
	 *
	 * @Route("/scan/", name="svwd_po_scan")
	 * @Template
	 * @AclAncestor("svwd_sale_view")
	 */

	public function scanAction( Request $request ) {

		if ( $request->get( 'search' ) ) {

			$from   = 'svwd_purchase_order';
			$string = $request->get( 'search' );

			/** @var $resultProvider ResultStatisticsProvider */
			$resultProvider = $this->get( 'oro_search.provider.result_statistics_provider' );
			$groupedResults = $resultProvider->getGroupedResults( $string );
			$selectedResult = null;

			foreach ( $groupedResults as $alias => $type ) {
				if ( $alias == $from ) {
					$selectedResult = $type;
				}
			}
		} else {
			$from           = 'svwd_purchase_order';
			$string         = 'Enter Search Term..';
			$groupedResults = false;
			$selectedResult = false;
		}

		return array(
			'from'           => $from,
			'searchString'   => $string,
			'groupedResults' => $groupedResults,
			'selectedResult' => $selectedResult
		);
//		return [
//			'entity_class' => $this->container->getParameter( 'svwd_sale.purchase_order.class' )
//		];
	}



    /**
     * @Route("/pdf/{id}", name="svwd_po_print_pdf", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function pdfAction(PurchaseOrder $purchaseOrder)
    {
        $html = $this->renderView('SoundViewSaleBundle:PurchaseOrder:label.html.twig', array(
            'entity'  => $purchaseOrder
        ));
        
        $dompdf = $this->get('slik_dompdf');
        
        $paper_size = array(0,0,450,288);
        
        //$dompdf->set_paper($paper_size);

        return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            //$dompdf->renderPdf($html),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename="'.$purchaseOrder->getPoNumber().'.pdf"'
            )
        );
    }
	
	/**
     * @Route("/po-book/{id}", name="svwd_sale_po_book", requirements={"id"="\d+"})
     * @Template
     * @AclAncestor("svwd_sale_view")
     */
    public function poBookAction(Sale $sale)
    {
        return array(
            'entity' => $sale,
            'po_edit_acl_resource' => 'svwd_sale_update'
        );
    }
    
    /**
     * @Route(
     *         "/widget/sale-po-info/{saleId}",
     *          name="svwd_po_widget_sale_po_info",
     *          requirements={"accountId"="\d+"}
     * )
     * @ParamConverter("sale", class="SoundViewSaleBundle:Sale", options={"id" = "saleId"})
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function salePosInfoAction(Sale $sale)
    {
        $purchaseOrders = $this->getDoctrine()
            ->getRepository('SoundView\Bundle\SaleBundle\Entity\PurchaseOrder')
            ->findBy(array(
                'salesOrder' => $sale
                )
            );

        return array('purchaseOrders' => $purchaseOrders, 'productCostTotal' => $sale->getProductCostTotal());
    }
    
    /**
     * @Route(
     *        "/widget/po-info/{id}",
     *        name="svwd_po_widget_po_info",
     *        requirements={"id"="\d+"}
     * )
     * @AclAncestor("svwd_sale_view")
     * @Template
     */
    public function poInfoAction(PurchaseOrder $purchaseOrder)
    {
        return ['entity' => $purchaseOrder];
    }

	/**
	 * @Route("/testEmail/{id}", requirements={"id"="\d+"}, name="svwd_po_email_test", defaults={"id"=0}))
	 * @AclAncestor("svwd_sale_view")
	 * @Template()
	 * @return int
	 */
	public function testEmailAction( PurchaseOrder $purchaseOrder ) {

		$em            = $this->get( 'doctrine.orm.entity_manager' );
		$emailTemplate = $em->getRepository( 'Oro\Bundle\EmailBundle\Entity\EmailTemplate' )->find( 11 );

		$mailer = $this->container->get( 'oro_email.direct_mailer' );


		$senderEmail = 'no-repy@soundviewseattle.com';
		$senderName  = 'Sound View Window & Door';

//		$emailTo = $entity->getSalesOrder()->getOwner()->getEmail();
		$emailTo = 'brandon@soundviewseattle.com';


		$subject = sprintf( 'PO# %s for SO# %s and Account %s Received', $purchaseOrder->getPoNumber(), $purchaseOrder->getSalesOrder()->getSoNumber(), $purchaseOrder->getSalesOrder()->getRelatedAccount() );

		list ( $subjectRendered, $templateRendered ) = $this->get( 'oro_email.email_renderer' )
		                                                    ->compileMessage( $emailTemplate, [ 'entity' => $purchaseOrder ] );


		$message = \Swift_Message::newInstance()
		                         ->setSubject( $subject )
		                         ->setFrom( $senderEmail, $senderName )
		                         ->setTo( $emailTo )
		                         ->setBody(
			                         $templateRendered,
			                         'text/html'
		                         );
		$mailer->send( $message );


		return 1;
	}





	/**
	 * @Route("/preview/{id}", requirements={"id"="\d+"}, name="svwd_po_email_preview", defaults={"id"=0}))
	 * @AclAncestor("svwd_sale_view")
	 * @Template("SoundViewSaleBundle:PurchaseOrder:preview.html.twig")
	 * @return array
	 */
	public function previewAction( PurchaseOrder $purchaseOrder ) {

		$em            = $this->get( 'doctrine.orm.entity_manager' );
		$emailTemplate = $em->getRepository( 'Oro\Bundle\EmailBundle\Entity\EmailTemplate' )->find( 11 );

		$email = $this->get( 'oro_email.email_renderer' )
		              ->compileMessage( $emailTemplate, [ 'entity' => $purchaseOrder ] );


		return array(
			'content'     => $email[1],
			'contentType' => $emailTemplate->getType()
		);
	}
	
   /**
    * @Route(
    *      "/po-update/{id}",
    *      name="svwd_po_update",
    *      requirements={"id"="\d+"},defaults={"id"=0},
	*      options={"expose"=true}
    * )
    * @Template
    * @AclAncestor("svwd_sale_update")
    */
   public function updateAction(PurchaseOrder $entity)
   {
       return $this->update($entity);
   }
	
	
	/**
    * @Route(
    *      "/{saleId}/po-create",
    *      name="svwd_po_create",
    *      requirements={"saleId"="\d+"},
	*      options={"expose"=true}
    * )
    * @Template("SoundViewSaleBundle:PurchaseOrder:update.html.twig")
    * @AclAncestor("svwd_sale_create")
    * @ParamConverter("sale", options={"id" = "saleId"})
    */
   public function createAction(Sale $sale)
   {   
       $entity = new PurchaseOrder();
       
       $entity->setSalesOrder($sale);
       
       
       return $this->update($entity);
   }
	
	/**
    * @param Sale $sale
    * @param PurchaseOrder $salePo
    * @return array
    * @throws BadRequestHttpException
    */
   protected function update(PurchaseOrder $entity)
   {
       if (!$entity) {
            $entity = $this->getManager()->createEntity();
        }

        return $this->get('oro_form.model.update_handler')->handleUpdate(
            $entity,
            $this->get('svwd_sale.purchase_order.form'),
            function (PurchaseOrder $entity) {
                return array(
                    'route' => 'svwd_po_update',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            function (PurchaseOrder $entity) {
                return array(
                    'route' => 'svwd_po_view',
                    'parameters' => array('id' => $entity->getId())
                );
            },
            'PO Saved',
            $this->get('svwd_sale.purchase_order.form.handler')
        );
       
//	$form  = $this->createForm($this->getFormType(), $salePo);
//        $responseData = array(
//           'saved' => false,
//           'entity' => $salePo
//       );
//        
//        
//
//       if ($this->getRequest()->getMethod() == 'GET' && !$salePo->getId()) {
//           $salePo->setSalesOrder($sale);
//       }
//
//       if ($salePo->getSalesOrder() && $salePo->getSalesOrder()->getId() != $sale->getId()) {
//           throw new BadRequestHttpException('PO must belong to Sale');
//       } elseif (!$salePo->getSalesOrder()) {
//           $salePo->setSalesOrder($sale);
//       }
//
//       if ($this->get('svwd_sale.purchase_order.form.handler.api')->process($salePo)) {
//           $this->getDoctrine()->getManager()->flush();
//           $responseData['entity'] = $salePo;
//           $responseData['saved'] = true;
//       }
//
//       $responseData['form'] = $this->get('svwd_sale.purchase_order.form.api')->createView();
//       return $responseData;
   }
   
    /**
     * @Route("/po/view/{id}", name="svwd_po_view", requirements={"id"="\d+"})
     *
     * @Template
     * @Acl(
     *      id="svwd_po_view",
     *      type="entity",
     *      permission="VIEW",
     *      class="SoundViewSaleBundle:PurchaseOrder"
     * )
     */
    public function viewAction(PurchaseOrder $salePo)
    {
		
        return [
            'entity' => $salePo
        ];
    }
	
	public function getInventory(SalePO $salePo)
	{
		$repo = $this->getRepository('SVWarehouseBundle:Inventory');
		
		$qb = $repo->getInventoryByPoNumber($salePo->getId());
		
		return $qb;	
		
	}

    /**
     * @return User
     */
    public function getCurrentUser()
    {
        $token = $this->container->get('security.context')->getToken();

        return $token ? $token->getUser() : null;
    }
	
	
	    /**
     * @return SalePOType
     */
    protected function getFormType()
    {
        return $this->get('svwd_sale.purchase_order.form.type.api');
    }
    /**
     * @return PurchaseOrderManager
     */
    protected function getPurchaseOrderManager()
    {
        return $this->get('svwd_sale.purchase_order.manager');
    }
	
	    /**
     * @param string $entityName
     * @return \Doctrine\Common\Persistence\ObjectRepository
     */
    protected function getRepository($entityName)
    {
        return $this->getDoctrine()->getRepository($entityName);
    }
	
}