<?php
/**
 * Created by PhpStorm.
 * User: soundview
 * Date: 12/23/14
 * Time: 2:07 PM
 */

namespace SoundView\Bundle\SaleBundle\Entity\Manager;

use Doctrine\ORM\EntityManager;


use Oro\Bundle\LocaleBundle\Formatter\NameFormatter;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\Repository\PurchaseOrderRepository;
use Oro\Bundle\SecurityBundle\ORM\Walker\AclHelper;
use Oro\Bundle\SecurityBundle\SecurityFacade;
use Oro\Bundle\UserBundle\Entity\User;

class PurchaseOrderManager {

    /** @var EntityManager */
    protected $em;

    /** @var SecurityFacade */
    protected $securityFacade;

    /** @var AclHelper */
    protected $aclHelper;

    /** @var NameFormatter */
    protected $nameFormatter;


    /**
     * @param EntityManager $em
     * @param SecurityFacade $securityFacade
     * @param AclHelper $aclHelper
     * @param NameFormatter $nameFormatter
     */
    public function __construct(
        EntityManager $em,
        SecurityFacade $securityFacade,
        AclHelper $aclHelper,
        NameFormatter $nameFormatter
    )
    {
        $this->em = $em;
        $this->securityFacade = $securityFacade;
        $this->aclHelper = $aclHelper;
        $this->nameFormatter = $nameFormatter;
    }

    /**
     * @param string $entityClass
     * @param int $entityId
     * @param string $sorting
     * @return Note[]
     */
    public function getList($entityId, $sorting)
    {
        /** @var PurchaseOrderRepository $repo */
        $repo = $this->em->getRepository('SoundViewSaleBundle:PurchaseOrder');
        $qb = $repo->getAssociatedPurchaseOrdersQueryBuilder($entityId)
            ->orderBy('po.createdAt', $sorting);

        //$query = $this->aclHelper->apply($qb, 'VIEW', false);

        return $qb->getQuery()->getResult();
    }

    /**
     * @param PurchaseOrder[] $entities
     * @return array
     */
    public function getEntityViewModels($entities)
    {
        $result = [];
        foreach ($entities as $entity) {
            $result[] = $this->getEntityViewModel($entity);
        }
        return $result;
    }

    /**
     * @param PurchaseOrder $entity
     * @return array
     */
    public function getEntityViewModel(PurchaseOrder $entity)
    {


        $result = [
            'id' => $entity->getId(),
            'title' => $entity->getPoNumber(),
            'createdAt' => $entity->getCreatedAt() ? $entity->getCreatedAt()->format('c') : '',
            'updatedAt' => $entity->getUpdatedAt() ? $entity->getUpdatedAt()->format('c') : '',
            'owner' => $this->nameFormatter->format($entity->getOwner()),
            'owner_id' => $entity->getOwnerId(),
            'eta' => $entity->getDeliveryEta() ? $entity->getDeliveryEta()->format('c') : '',
            'vendor' => $entity->getVendor() ? $entity->getVendor()->getLabel() : NULL,
            'received' => $entity->isReceived(),
            'deliveredOn' => $entity->getDeliveredOn() ? $entity->getDeliveredOn()->format('c') : '',
            'itemCount' => $entity->getItemCountString(),
            'status' => $entity->getStatus() ? $entity->getStatus()->getLabel() : NULL
            
        ];


        return $result;
    }

}
