<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;
use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\TagBundle\Entity\Taggable;
use Oro\Bundle\OrganizationBundle\Entity\Organization;

use OroCRM\Bundle\ChannelBundle\Model\ChannelEntityTrait;
use OroCRM\Bundle\ChannelBundle\Model\ChannelAwareInterface;


use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;

use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;
use SoundView\Bundle\SaleBundle\Entity\Payment;
use SoundView\Bundle\CommissionBundle\Entity\Commission;

use SoundView\Bundle\SaleBundle\Model\ExtendSale;



 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_sale",
 *      indexes={@ORM\Index(name="svwd_sales_order_idx",columns={"order_number"})}
 * )
 * @ORM\Entity(repositoryClass="SoundView\Bundle\SaleBundle\Entity\Repository\SaleRepository")
 * @ORM\HasLifecycleCallbacks()
 * @UniqueEntity(
 *     fields="soNumber",
 *     message="Sales Order already exists."
 * )
 * @Oro\Loggable
 * @Config(
 *      routeName="svwd_sale_index",
 *      routeView="svwd_sale_view",
 *      defaultValues={
 *          "entity"={
 *              "icon"="icon-list-alt"
 *          },
 *          "ownership"={
 *              "owner_type"="USER",
 *              "owner_field_name"="owner",
 *              "owner_column_name"="owner_id",
 *              "organization_field_name"="organization",
 *              "organization_column_name"="organization_id"
 *          },
 *          "security"={
 *              "type"="ACL",
 *              "group_name"=""
 *          },
 *          "dataaudit"={
 *              "auditable"=true
 *          }
 *      }
 * )
 */
 
 
 
class Sale extends ExtendSale implements Taggable, ChannelAwareInterface
{
    use ChannelEntityTrait;
    

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="order_number", type="string", length=255, nullable=true, unique=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $soNumber;
    
    
    /**
    * @var string
    *
    * @ORM\Column(name="job_name", type="string", length=255, nullable=true)
    * @Oro\Versioned
    * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
    */
    protected $jobName;

    /**
     * @var SaleType
     *
     * @ORM\ManyToOne(targetEntity="SaleType")
     * @ORM\JoinColumn(name="order_type", referencedColumnName="name", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $orderType;
    
    /**
     * @var SaleStatus
     *
     * @ORM\ManyToOne(targetEntity="SaleStatus")
     * @ORM\JoinColumn(name="order_status", referencedColumnName="name", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $status;
    
     /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\SaleBundle\Entity\PurchaseOrder",
     *    mappedBy="salesOrder", cascade={"all"}, orphanRemoval=true
     * )
     * @ORM\OrderBy({"createdAt" = "ASC"})
     * @Oro\Versioned
     * @Soap\ComplexType("SoundView\Bundle\SaleBundle\Entity\PurchaseOrder[]", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          },
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *      }
     * )
     */
    protected $purchaseOrders;
    
    
    /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\SaleBundle\Entity\Payment",
     *    mappedBy="salesOrder", cascade={"all"}, orphanRemoval=true
     * )
     * @ORM\OrderBy({"createdAt" = "DESC"})
     * @Soap\ComplexType("SoundView\Bundle\SaleBundle\Entity\Payment[]", nillable=true)
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          }
     *      }
     * )
     */
    protected $payments;
	
	 /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\CommissionBundle\Entity\Commission",
     *    mappedBy="sale", cascade={"all"}, orphanRemoval=true
     * )
     * @ORM\OrderBy({"createdAt" = "DESC"})
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          }
     *      }
     * )
     */
    protected $commissions;
    
    /**
     * @var double
     *
     * @ORM\Column(name="product_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
     
     protected $productAmount = 0;
     
         /**
     * @var double
     *
     * @ORM\Column(name="product_cost", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
     
     protected $productCost;
     
     /**
     * @var double
     *
     * @ORM\Column(name="labor_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
     
     protected $laborAmount = 0;
     
     
     /**
     * @var double
     *
     * @ORM\Column(name="adjustment_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $adjustmentAmount;
     
     /**
     * @var double
     *
     * @ORM\Column(name="subtotal_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $subtotalAmount;
    
    
    /**
     * @var double
     *
     * @ORM\Column(name="fee_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $feeAmount;
    
    /**
     * @var float
     *
     * @ORM\Column(name="fee_percent", type="percent", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $feePercent;
    
    /**
     * @var double
     *
     * @ORM\Column(name="tax_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $taxAmount;
    
    /**
     * @var float
     *
     * @ORM\Column(name="tax_percent", type="percent", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $taxPercent;

    /**
     * @var double
     *
     * @ORM\Column(name="discount_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $discountAmount;

    /**
     * @var float
     *
     * @ORM\Column(name="discount_percent", type="percent", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )     
     */
    protected $discountPercent;

    /**
     * @var double
     *
     * @ORM\Column(name="total_amount", type="money", nullable=true)
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $totalAmount;
    
    
    /**
     * @var SaleStatus
     *
     * @ORM\ManyToOne(targetEntity="PaymentMethod")
     * @ORM\JoinColumn(name="payment_method_name", referencedColumnName="name", nullable=true, onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $paymentMethod;
     

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="owner_id", referencedColumnName="id", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $owner;

    /**
     * @var Organization
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\OrganizationBundle\Entity\Organization")
     * @ORM\JoinColumn(name="organization_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "dataaudit"={
     *              "auditable"=true
     *          },
     *          "importexport"={
     *              "order"=190,
     *              "short"=true
     *          }
     *      }
     * )
     */
    protected $organization;

    /**
     * @var Account
     *
     * @ORM\ManyToOne(targetEntity="OroCRM\Bundle\AccountBundle\Entity\Account")
     * @ORM\JoinColumn(name="related_account_id", referencedColumnName="id", onDelete="SET NULL")
     * @Oro\Versioned
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "dataaudit"={
     *              "auditable"=true
     *          }
     *  }
     * )
     */
    protected $relatedAccount;

    /**
     * @var Contact
     *
     * @ORM\ManyToOne(targetEntity="OroCRM\Bundle\ContactBundle\Entity\Contact")
     * @ORM\JoinColumn(name="related_contact_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true}
     *  }
     * )
     */
    protected $relatedContact;


	
    /**
     * @var bool
     *
     * @ORM\Column(name="acknowledged", type="boolean")
     */
    protected $acknowledged = 0;
	
    /**
     * @var bool
     *
     * @ORM\Column(name="completed", type="boolean")
    */
    protected $completed = 0;

        /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="created_by_user_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "excluded"=true
     *          }
     *      }
     * )
     */
    protected $createdBy;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="Oro\Bundle\UserBundle\Entity\User")
     * @ORM\JoinColumn(name="updated_by_user_id", referencedColumnName="id", onDelete="SET NULL")
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "excluded"=true
     *          }
     *      }
     * )
     */
    protected $updatedBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "entity"={
     *              "label"="oro.ui.created_at"
     *          }
     *  }
     * )
     */
    protected $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime", nullable=true)
     * @ConfigField(
     *  defaultValues={
     *      "email"={"available_in_template"=true},
     *      "entity"={
     *              "label"="oro.ui.updated_at"
     *          }
     *  }
     * )
     */
    protected $updatedAt;

    /**
     * @var ArrayCollection $tags
     * @ConfigField(
     *      defaultValues={
     *          "merge"={
     *              "display"=true
     *          }
     *      }
     * )
     */
    protected $tags;


    
    public function __construct()
    {
        parent::__construct();

        $this->payments = new ArrayCollection();
	    $this->commissions = new ArrayCollection();

    }
    
    
        /**
     * Get entity class name.
     * TODO: Remove this temporary solution for get 'view' route in twig after EntityConfigBundle is finished
     * @return string
     */
//    public function getClass()
//    {
//        return 'SoundView\Bundle\SaleBundle\Entity\Sale';
//    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set orderNumber
     *
     * @param string $orderNumber
     * @return SalesOrder
     */
    public function setSoNumber($orderNumber)
    {
        $this->soNumber = $orderNumber;

        return $this;
    }

    /**
     * Get orderNumber
     *
     * @return string 
     */
    public function getSoNumber()
    {
        return $this->soNumber;
    }
    
    
    
     /**
     * Set jobName
     *
     * @param string $jobName
     * @return Sale
     */
    public function setJobName($jobName)
    {
        $this->jobName = $jobName;

        return $this;
    }

    /**
     * Get jobName
     *
     * @return string 
     */
    public function getJobName()
    {
        return $this->jobName;
    }



    /**
     * Get purchaseOrders
     *
     * @return Collection|PurchaseOrders[]
     */
    public function getPurchaseOrders()
    {
        return $this->purchaseOrders;
    }

    
    

    /**
     * Get payments
     *
     * @return Collection|Payments[]
     */
    public function getPayments()
    {
        return $this->payments;
    }
	
	
    public function hasFirstHalfPayment()
    {
	$result = false;

        foreach ($this->getPayments() as $payment) {
            if ($payment->isFirstHalf()) {
                $result = true;
                break;
            }
        }

        return $result;
		
    }
	
    public function hasFinalPayment()
    {
	$result = false;

        foreach ($this->getPayments() as $payment) {
            if ($payment->isFinal()) {
                $result = true;
                break;
            }
        }

        return $result;
		
    }

    public function getFirstHalfPayment()
    {
	$result = NULL;
        if($this->getPayments()){

            foreach ($this->getPayments() as $payment) {
                if ($payment->isFirstHalf()) {
                    $result = $payment;
                    break;
                }
            }

        }

        return $result;
		
    }
	
    public function getFinalPayment()
    {
        $result = NULL;

        foreach ($this->getPayments() as $payment) {
            if ($payment->isFinal()) {
                $result = $payment;
                break;
            }
        }

        return $result;
		
    }
	
    /**
     * Get payments
     *
     * @return Collection|Payments[]
     */
    public function getCommissions()
    {
        return $this->commissions;
    }
	
	public function getFirstHalfCommission()
	{
		$result = NULL;
		foreach($this->getCommissions() as $commission){
			if($commission->isFirstHalf()) {
				$result = $commission;
				break;	
			}
		}
		return $result;
	}
	
	public function getSecondHalfCommission()
	{
		$result = NULL;
		foreach($this->getCommissions() as $commission){
			if($commission->isSecondHalf()) {
				$result = $commission;
				break;	
			}
		}
		return $result;
	}
    
    /**
    * Get total paid
    *
    * @return double
    */
    public function getTotalPaid()
    {
        $totalPaid = NULL;
        
        foreach($this->getPayments() as $payment) {
            $totalPaid += $payment->getAmount();    
        }

        return $totalPaid;
    }
    
    /**
    * Get balance
    *
    * @return double
    */
    public function getTotalBalance()
    {
        $balance = 0;
        
        $balance += $this->getTotalAmount();
        $balance -= $this->getTotalPaid();
            

        return $balance;
    }
    

    
     /**
     * @param float $productAmount
     *
     * @return $this
     */
    public function setProductAmount($productAmount)
    {
        $this->productAmount = $productAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getProductAmount()
    {
        return $this->productAmount;
    }

    public function getFee()
    {
        $fee = NULL;
        if($this->getPaymentMethod() && $this->getPaymentMethod()->getFee() > 0) {
            $fee = $this->getPaymentMethod()->getFee();
            $fee = ($fee / 100) + 1;
            $fee = 100 / ($fee * 100);
        }
        return $fee;
    }

    public function getRealSell()
    {
        $realSell = NULL;
        if($this->getFee())
        {
            $fee = $this->getFee();
            $realSell = $this->getProductAmount() * $fee;
        }
        return $realSell;
    }

    public function getRealInstall()
    {
        $realSell = NULL;
        if($this->getFee())
        {
            $fee = $this->getFee();
            $realSell = $this->getLaborAmount() * $fee;
        }
        return $realSell;
    }
    
     /**
     * @param float $laborAmount
     *
     * @return $this
     */
    public function setLaborAmount($laborAmount)
    {
        $this->laborAmount = $laborAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getLaborAmount()
    {
        return $this->laborAmount;
    }
    
         /**
     * @param float $saleAmount
     *
     * @return $this
     */
    public function setAdjustmentAmount($adjustmentAmount)
    {
        $this->adjustmentAmount = $adjustmentAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getAdjustmentAmount()
    {
        return $this->adjustmentAmount;
    }
    
    
    
        /**
     * @param float $discountAmount
     *
     * @return $this
     */
    public function setDiscountAmount($discountAmount)
    {
        $this->discountAmount = $discountAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }

    /**
     * @param float $discountPercent
     *
     * @return $this
     */
    public function setDiscountPercent($discountPercent)
    {
        $this->discountPercent = $discountPercent;

        return $this;
    }

    /**
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->discountPercent;
    }
    
        /**
     * @param float $feeAmount
     *
     * @return $this
     */
    public function setFeeAmount($feeAmount)
    {
        $this->feeAmount = $feeAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getFeeAmount()
    {
        return $this->feeAmount;
    }

    /**
     * @param float $feePercent
     *
     * @return $this
     */
    public function setFeePercent($feePercent)
    {
        $this->feePercent = $feePercent;

        return $this;
    }

    /**
     * @return float
     */
    public function getFeePercent()
    {
        return $this->feePercent;
    }
    
        /**
     * @param float $subtotalAmount
     *
     * @return $this
     */
    public function setSubtotalAmount($subtotalAmount)
    {
        $this->subtotalAmount = $subtotalAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getSubtotalAmount()
    {
        return $this->subtotalAmount;
    }

    /**
     * @param float $taxAmount
     *
     * @return $this
     */
    public function setTaxAmount($taxAmount)
    {
        $this->taxAmount = $taxAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    
     /**
     * @param float $taxPercent
     *
     * @return $this
     */
    public function setTaxPercent($taxPercent)
    {
        $this->taxPercent = $taxPercent;

        return $this;
    }

    /**
     * @return float
     */
    public function getTaxPercent()
    {
        return $this->taxPercent;
    }
    
        /**
     * @param float $totalAmount
     *
     * @return $this
     */
    public function setTotalAmount($totalAmount)
    {
        $this->totalAmount = $totalAmount;

        return $this;
    }

    /**
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    
    
     /**
     * @return float
     */
    public function getProductCost()
    {
        return $this->productCost;
    }

    public function getProductCostTotal()
    {

        $result = 0;

      
        foreach($this->getPurchaseOrders() as $purchaseOrder) {
            $result += $purchaseOrder->getOrderAmount();    
        }
        

        return $result;

    }
    
    

    /**
     * @param float $saleCost
     *
     * @return $this
     */
    public function setProductCost($productCost)
    {
        $this->productCost = $productCost;

        return $this;
    }
    

    /**
     * @return User
     */
    public function getOwner()
    {
        return $this->owner;
    }

    /**
     * @return mixed|null
     */
    public function getOwnerId()
    {
        return $this->getOwner() ? $this->getOwner()->getId() : null;
    }

    /**
     * @param User $owner
     */
    public function setOwner($owner = null)
    {
        $this->owner = $owner;
    }

    /**
     * @return Account
     */
    public function getRelatedAccount()
    {
        return $this->relatedAccount;
    }

    /**
     * @return mixed|null
     */
    public function getRelatedAccountId()
    {
        return $this->getRelatedAccount() ? $this->getRelatedAccount()->getId() : null;
    }

    /**
     * @param Account $account
     */
    public function setRelatedAccount($account = null)
    {
        $this->relatedAccount = $account;
    }

    /**
     * @return Contact
     */
    public function getRelatedContact()
    {
        return $this->relatedContact;
    }

    /**
     * @return Contact
     */
    public function getRelatedContactId()
    {
        return $this->getRelatedContact() ? $this->getRelatedContact()->getId() : null;
    }

    /**
     * @param Contact $contact
     */
    public function setRelatedContact($contact = null)
    {
        $this->relatedContact = $contact;
    }



    /**
     * @param SaleStatus $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return Status
     */
    public function getStatus()
    {
        return $this->status;
    }
    
    /**
     * @param PaymentMethod $method
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return Status
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    
        /**
     * @param SaleType $saleType
     */
    public function setOrderType($orderType)
    {

        $this->orderType = $orderType;
    }

    /**
     * @return SaleType
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
	
	
	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isAcknowledged()
    {
        return (bool) $this->acknowledged;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setAcknowledged($acknowledged)
    {
        $this->acknowledged = (bool) $acknowledged;

        return $this;
    }
	
	/**
     * Indicates whether an event occurs at a specific time-of-day.
     *
     * @return bool
     */
    public function isCompleted()
    {
        return (bool) $this->completed;
    }

    /**
     * Sets a flag indicates whether an event occurs at a specific time-of-day.
     *
     * @param bool $allDay
     * @return CalendarEvent
     */
    public function setCompleted($completed)
    {
        $this->completed = (bool) $completed;

        return $this;
    }

        /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param  \DateTime   $created
     * @return Opportunity
     */
    public function setCreatedAt($created)
    {
        $this->createdAt = $created;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param  \DateTime   $updated
     * @return Opportunity
     */
    public function setUpdatedAt($updated)
    {
        $this->updatedAt = $updated;

        return $this;
    }

    /**
     * @param \Oro\Bundle\UserBundle\Entity\User $createdBy
     *
     * @return Contact
     */
    public function setCreatedBy($createdBy)
    {
        $this->createdBy = $createdBy;

        return $this;
    }

    /**
     * @return \Oro\Bundle\UserBundle\Entity\User
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }

    /**
     * @param \Oro\Bundle\UserBundle\Entity\User $updatedBy
     *
     * @return Contact
     */
    public function setUpdatedBy($updatedBy)
    {
        $this->updatedBy = $updatedBy;

        return $this;
    }

    /**
     * @return \Oro\Bundle\UserBundle\Entity\User
     */
    public function getUpdatedBy()
    {
        return $this->updatedBy;
    }

    /**
     * {@inheritdoc}
     */
    public function getTaggableId()
    {
        return $this->getId();
    }

    /**
     * {@inheritdoc}
     */
    public function getTags()
    {
        $this->tags = $this->tags ?: new ArrayCollection();

        return $this->tags;
    }

    /**
     * {@inheritdoc}
     */
    public function setTags($tags)
    {
        $this->tags = $tags;

        return $this;
    }
    
        /**
     * @return string
     */
    public function __toString()
    {
        $name = $this->getSoNumber() . ' '
            . $this->getJobName();
        $name = preg_replace('/ +/', ' ', $name);

        return (string) trim($name);
    }
	
	public function isFirstHalfReady()
	{
		return $this->getStatus()->getName() == 'acknowledged' ? true: false;	
	}
	
	public function isSecondHalfReady()
	{
		return $this->isCompleted() == 1 ? true : false;
			
	}
    

        /**
     * Set organization
     *
     * @param Organization $organization
     * @return Sale
     */
    public function setOrganization(Organization $organization = null)
    {
        $this->organization = $organization;

        return $this;
    }

    /**
     * Get organization
     *
     * @return Organization
     */
    public function getOrganization()
    {
        return $this->organization;
    }
}
