<?php

namespace SoundView\Bundle\SaleBundle\Entity;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;

use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;
use Oro\Bundle\ReminderBundle\Entity\RemindableInterface;
use Oro\Bundle\ReminderBundle\Model\ReminderData;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowItem;
use Oro\Bundle\WorkflowBundle\Entity\WorkflowStep;

use OroCRM\Bundle\AccountBundle\Entity\Account;
use OroCRM\Bundle\ContactBundle\Entity\Contact;



 /**
 * @ORM\Entity
 * @ORM\Table(
 *      name="svwd_vendor",
 * )
 */
 
 
 
class Vendor
{
	 /**
     * @var string
     *
	 * @ORM\Id
     * @ORM\Column(name="name", type="string", length=32)
     */
    protected $name;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, unique=true)
     */
    protected $label;
	
	/**
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }
	

    /**
     * Get Vendor name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set vendor label
     *
     * @param string $label
     * @return SaleVendor
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get vendor label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }
	
	    /**
     * @return string
     */
    public function __toString()
    {
        return (string) $this->label;
    }
}
