<?php

namespace SoundView\Bundle\SaleBundle\Form\Handler;

use Doctrine\Common\Persistence\ObjectManager;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;

use SoundView\Bundle\SaleBundle\Entity\Sale;
use SoundView\Bundle\SaleBundle\Entity\PurchaseOrder;

class PurchaseOrderHandler
{
    /**
     * @var FormInterface
     */
    protected $form;

    /**
     * @var Request
     */
    protected $request;

    /**
     * @var ObjectManager
     */
    protected $manager;

    /**
     *
     * @param FormInterface $form
     * @param Request       $request
     * @param ObjectManager $manager
     */
    public function __construct(FormInterface $form, Request $request, ObjectManager $manager)
    {
        $this->form    = $form;
        $this->request = $request;
        $this->manager = $manager;
    }

    /**
     * Process form
     *
     * @param  SalePO $entity
     * @return bool True on successful processing, false otherwise
     */
    public function process(PurchaseOrder $entity)
    {
        $this->form->setData($entity);

        if (in_array($this->request->getMethod(), array('POST', 'PUT'))) {
            $this->form->submit($this->request);

            if ($this->form->isValid()) {
                $this->onSuccess($entity);

                return true;
            }
        }

        return false;
    }
	
	/**
     * Process receive form
     *
     * @param  SalePO $entity
     * @return bool True on successful processing, false otherwise
     */
    public function receive(PurchaseOrder $entity)
    {
        $this->form->setData($entity);

        if (in_array($this->request->getMethod(), array('GET'))) {
            $this->form->submit($this->request);

            if ($this->form->isValid()) {
                $this->onSuccess($entity);

                return true;
            }
        }

        return false;
    }

    /**
     * "Success" form handler
     *
     * @param SalePO $entity
     */
    protected function onSuccess(PurchaseOrder $salePo)
    {
        $this->manager->persist($salePo);
        $this->manager->flush();
    }
}
