<?php
/**
 * Created by PhpStorm.
 * User: brandon
 * Date: 12/19/14
 * Time: 3:15 PM
 */

namespace SoundView\Bundle\SaleBundle\Form\Type;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class OrderItemCountType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', 'hidden')
            ->add(
                'itemCount',
                'text',
                array(
                    'label' => 'Count',
                    'required' => true
                )
            )
            ->add(
                'itemType',
                'entity',
                [
                    'label' => 'Type',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\ItemType',
                    'required' => true,
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('type')->orderBy('type.order');
                    }
                ]
            );
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_item_count';
    }
}