<?php

namespace SoundView\Bundle\SaleBundle\Form\Type;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections\Collection;

use Symfony\Component\Routing\Router;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

use Oro\Bundle\LocaleBundle\Formatter\NameFormatter;
use Oro\Bundle\SecurityBundle\SecurityFacade;


class SaleType extends AbstractType
{
     /**
     * @var Router
     */
    protected $router;

    /**
     * @var NameFormatter
     */
    protected $nameFormatter;

    /**
     * @var SecurityFacade
     */
    protected $securityFacade;

     /**
     * @param Router $router
     * @param NameFormatter $nameFormatter
     * @param SecurityFacade $securityFacade
     */
    public function __construct(Router $router, NameFormatter $nameFormatter, SecurityFacade $securityFacade)
    {
        $this->nameFormatter  = $nameFormatter;
        $this->router         = $router;
        $this->securityFacade = $securityFacade;

    }
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'dataChannel',
                'orocrm_channel_select_type',
                array(
                    'required' => true,
                    'label' => 'orocrm.sales.lead.data_channel.label',
                    'entities' => [
                        'SoundView\\Bundle\\SaleBundle\\Entity\\Sale'
                    ],
                )
            )
            ->add(
                'soNumber',
                'text',
                [
                    'required' => false,
                    'label' => 'SO#'
                ]
            )
			->add(
                'jobName',
                'text',
                [
                    'required' => false,
                    'label' => 'Job Name'
                ]
            )
			->add(
				'orderType',
				'entity',
				[
                    'label' => 'Type',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\SaleType',
                    'required' => false,
					'empty_value' => 'Select Type',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('type')->orderBy('type.order');
                    }
                ]
			)
			->add(
				'status',
				'entity',
				[
                    'label' => 'Status',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\SaleStatus',
                    'required' => false,
					'empty_value' => 'Select Status',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('status')->orderBy('status.order');
                    }
                ]
			)
                    // tags
            ->add(
                'tags',
                'oro_tag_select',
                array(
                    'label' => 'oro.tag.entity_plural_label'
                )
            )
			->add(
				'paymentMethod',
				'entity',
				[
                    'label' => 'Sell Type',
                    'class' => 'SoundView\Bundle\SaleBundle\Entity\PaymentMethod',
                    'required' => false,
					'empty_value' => 'Select Sell Type',
                    'query_builder' => function (EntityRepository $repository) {
                        return $repository->createQueryBuilder('method')->orderBy('method.order');
                    }
                ]
			)		
			->add(
                'productAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Product'
				]
            )
			->add(
                'laborAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Labor'
				]
            )
			->add(
                'adjustmentAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Adjustment'
				]
            )
			->add(
                'subtotalAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Sub Total'
				]
            )
			->add(
                'feePercent',
                'oro_percent',
                [
					'required' => false, 
					'label' => 'Fees'
				]
            )
			->add(
                'feeAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Fees'
				]
            )
			->add(
                'taxPercent',
                'oro_percent',
                [
					'required' => false, 
					'label' => 'Tax'
				]
            )
			->add(
                'taxAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Tax'
				]
            )
			->add(
                'totalAmount',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Total'
				]
            )
            ->add(
                'productCost',
                'oro_money',
                [
					'required' => false, 
					'label' => 'Sale Cost'
				]
            )
            ->add(
                'relatedAccount',
                'orocrm_account_select',
                [
                    'required' => false,
                    'label' => 'Account'
                ]
            )
            ->add(
                'relatedContact',
                'orocrm_contact_select',
                [
                    'required' => false,
                    'label' => 'Contact'
                ]
            )
            ->add(
                'owner',
                'oro_user_select',
                [
                    'required' => true,
                    'label' => 'Owner'
                ]
            )
			->add(
				'acknowledged',
				'checkbox',
				[
					'required' => false,
					'label' => 'Order Acknowledged'
				]
			)
			->add(
				'completed',
				'checkbox',
				[
					'required' => false,
					'label' => 'Job Completed'
				]
			);
			
			//$builder->add(
//            'poNumbers',
//            'sv_po_collection',
//             array(
//                'label'    => '',
//                'type'     => 'sv_po',
//                'required' => false,
//                'options'  => array('data_class' => 'SoundView\Bundle\SaleBundle\Entity\SalePO')
//            )
//        );
    }





    /**
     * {@inheritdoc}
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => 'SoundView\Bundle\SaleBundle\Entity\Sale',
                'intention' => 'sale',
                'cascade_validation' => true,
				'csrf_protection' => false
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'svwd_sale';
    }
}
