<?php

namespace SoundView\Bundle\SaleBundle\Migrations\Data\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;

use Doctrine\Common\DataFixtures\AbstractFixture;

use SoundView\Bundle\SaleBundle\Migrations\Schema\v1_0\SoundViewSaleBundle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\PropertyAccess\PropertyAccess;

use Oro\Bundle\ActivityListBundle\Provider\ActivityListChainProvider;
use Oro\Bundle\OrganizationBundle\Entity\Organization;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\SecurityBundle\Authentication\Token\UsernamePasswordOrganizationToken;
use Oro\Bundle\BatchBundle\ORM\Query\BufferedQueryResultIterator;


class UpdatePurchaseOrderEntitiesWithOwner extends AbstractFixture implements ContainerAwareInterface
{
    const BATCH_SIZE = 300;

    const ENTITY_CLASS = 'SoundViewSaleBundle:PurchaseOrder';

    /** @var ContainerInterface */
    protected $container;

    /**
     * {@inheritdoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $this->addOwnerData($manager, 'SoundViewSaleBundle:PurchaseOrder');
    }

    public function addOwnerData(
        ObjectManager $manager,
        $entityClass
    ) {
        if ($this->container->hasParameter('installed') && $this->container->getParameter('installed')) {
            $queryBuilder = $manager->getRepository($entityClass)->createQueryBuilder('entity');
            $iterator     = new BufferedQueryResultIterator($queryBuilder);
            $iterator->setBufferSize(self::BATCH_SIZE);

            $itemsCount = 0;
            $entities   = [];

            foreach ($iterator as $entity) {
                $entities[] = $entity;
                $itemsCount++;

                if (0 == $itemsCount % self::BATCH_SIZE) {
                    $this->saveOwnerData($manager, $entities);
                    $entities = [];
                }
            }

            if ($itemsCount % static::BATCH_SIZE > 0) {
                $this->saveOwnerData($manager, $entities);
            }
        }
    }

    /**
     * @param ObjectManager             $manager
     * @param array                     $entities
     */
    protected function saveOwnerData(
        ObjectManager $manager,
        $entities
    ) {
        foreach ($entities as $entity) {

            $owner = $entity->getSalesOrder()->getOwner();

            if ($owner instanceof User) {
                $entity->setOwner($owner);
            }

            $manager->persist($entity);
        }
        $manager->flush();
    }

    /**
     * @param User         $user
     * @param Organization $organization
     */
    protected function setSecurityContext(User $user, Organization $organization)
    {
        $securityContext = $this->container->get('security.context');
        $token           = new UsernamePasswordOrganizationToken($user, $user->getUsername(), 'main', $organization);
        $securityContext->setToken($token);
    }
}
