<?php

namespace SoundView\Bundle\SaleBundle\Migrations\Data\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;

use Doctrine\Common\DataFixtures\AbstractFixture;

use SoundView\Bundle\SaleBundle\Migrations\Schema\v1_0\SoundViewSaleBundle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\PropertyAccess\PropertyAccess;

use Oro\Bundle\ActivityListBundle\Provider\ActivityListChainProvider;
use Oro\Bundle\OrganizationBundle\Entity\Organization;
use Oro\Bundle\UserBundle\Entity\User;
use Oro\Bundle\SecurityBundle\Authentication\Token\UsernamePasswordOrganizationToken;
use Oro\Bundle\BatchBundle\ORM\Query\BufferedQueryResultIterator;
use SoundView\Bundle\SaleBundle\Entity\OrderItemCount;


class UpdatePurchaseOrderItemCounts extends AbstractFixture implements ContainerAwareInterface
{
    const BATCH_SIZE = 300;

    const ENTITY_CLASS = 'SoundViewSaleBundle:PurchaseOrder';

    /** @var ContainerInterface */
    protected $container;

    protected $itemType;

    /**
     * {@inheritdoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
        $this->itemType = $this->getItemType();
    }


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $this->addItemCountData($manager, 'SoundViewSaleBundle:PurchaseOrder');
    }

    public function addItemCountData(
        ObjectManager $manager,
        $entityClass
    ) {
        if ($this->container->hasParameter('installed') && $this->container->getParameter('installed')) {
            $queryBuilder = $manager->getRepository($entityClass)->createQueryBuilder('entity');
            $iterator     = new BufferedQueryResultIterator($queryBuilder);
            $iterator->setBufferSize(self::BATCH_SIZE);

            $itemsCount = 0;
            $entities   = [];

            foreach ($iterator as $entity) {
                $entities[] = $entity;
                $itemsCount++;

                if (0 == $itemsCount % self::BATCH_SIZE) {
                    $this->saveItemCountData($manager, $entities);
                    $entities = [];
                }
            }

            if ($itemsCount % static::BATCH_SIZE > 0) {
                $this->saveItemCountData($manager, $entities);
            }
        }
    }

    /**
     * @param ObjectManager             $manager
     * @param array                     $entities
     */
    protected function saveItemCountData(
        ObjectManager $manager,
        $entities
    ) {
        foreach ($entities as $entity) {

            $itemsCount = $entity->getItemsCount();

            if ($itemsCount !== NULL) {
                $count = new OrderItemCount();
                $count->setItemCount($itemsCount);
                $count->setItemType($this->itemType);
                $entity->addItemCount($count);
            }

            $manager->persist($entity);
        }
        $manager->flush();
    }

    protected function getItemType()
    {
        $repo = $this->container->get('doctrine')->getRepository('SoundViewSaleBundle:ItemType');
        $itemType = $repo->findOneByName('total');
        return $itemType;
    }

    /**
     * @param User         $user
     * @param Organization $organization
     */
    protected function setSecurityContext(User $user, Organization $organization)
    {
        $securityContext = $this->container->get('security.context');
        $token           = new UsernamePasswordOrganizationToken($user, $user->getUsername(), 'main', $organization);
        $securityContext->setToken($token);
    }
}
