<?php

namespace SoundView\Bundle\WarehouseBundle\Entity;

use BeSimple\SoapBundle\ServiceDefinition\Annotation as Soap;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\Config;
use Oro\Bundle\EntityConfigBundle\Metadata\Annotation\ConfigField;
use Oro\Bundle\DataAuditBundle\Metadata\Annotation as Oro;

/**
 * @ORM\Entity
 * @ORM\Table(name="svwd_inventory_location")
 * @Oro\Loggable
 */
class InventoryLocation {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    protected $name;
    
    /**
     * @var string
     *
     * @ORM\Column(name="row", type="string", length=255)
     */
    protected $row;
    
    /**
     * @var string
     *
     * @ORM\Column(name="side", type="string", length=255)
     */
    protected $side;
    
    /**
     * @var Collection
     *
     * @ORM\OneToMany(targetEntity="SoundView\Bundle\WarehouseBundle\Entity\Inventory",
     *    mappedBy="location", cascade={"all"}, orphanRemoval=true
     * )
     * @ORM\OrderBy({"createdAt" = "ASC"})
     * @Oro\Versioned
     * @ConfigField(
     *      defaultValues={
     *          "importexport"={
     *              "order"=210
     *          },
     *          "dataaudit"={
     *              "auditable"=true
     *          }
     *      }
     * )
     */
    protected $orders;
    
    
    public function __construct($orders = null) {
        $this->orders = $orders;
    }
     /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id
     *
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    
    public function getName()
    {
        return $this->name;
    }
    
    public function getRow()
    {
        return $this->row;
    }
    
    public function getSide()
    {
        return $this->side;
    }
    
    public function getOrders()
    {
        return $this->orders;
    }
    
    public function __toString() {
        
        $name =  $this->getName();
        
        return $name;
    }
    //put your code here
}