<?php

namespace Oro\Bundle\IntegrationBundle\Tests\Unit\Model\Action;

use Symfony\Component\PropertyAccess\PropertyPath;

use Oro\Bundle\IntegrationBundle\Manager\FieldsChangesManager;
use Oro\Bundle\IntegrationBundle\Model\Action\SaveFieldsChangesAction;
use Oro\Bundle\WorkflowBundle\Model\ContextAccessor;
use Oro\Bundle\WorkflowBundle\Model\ProcessData;

class SaveFieldsChangesActionTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var SaveFieldsChangesAction
     */
    protected $action;

    protected function setUp()
    {
        $contextAccessor = new ContextAccessor();
        $this->action    = new SaveFieldsChangesAction($contextAccessor);
        $dispatcher = $this->getMockBuilder('Symfony\Component\EventDispatcher\EventDispatcher')
            ->disableOriginalConstructor()
            ->getMock();
        $this->action->setDispatcher($dispatcher);
    }

    /**
     * @param array  $options
     * @param string $message
     *
     * @dataProvider initializeDataProvider
     */
    public function testInitializeFailed(array $options, $message = null)
    {
        if ($message) {
            $this->setExpectedException(
                'Oro\Bundle\WorkflowBundle\Exception\InvalidParameterException',
                $message
            );
        }

        $this->action->initialize($options);
    }

    /**
     * @return array
     */
    public function initializeDataProvider()
    {
        return [
            'empty'     => [
                [],
                'changeSet parameter is required'
            ],
            'changeSet' => [
                ['changeSet' => ['value']],
                'Entity parameter is required'
            ],
            'full'      => [
                ['changeSet' => ['value'], 'entity' => ['value']],
                null
            ],
        ];
    }

    /**
     * @param array $options
     * @param array $context
     *
     * @dataProvider executeDataProvider
     */
    public function testExecuteAction(array $options, array $context)
    {
        /** @var FieldsChangesManager|\PHPUnit_Framework_MockObject_MockObject $fieldsChangesManager */
        $fieldsChangesManager = $this
            ->getMockBuilder('Oro\Bundle\IntegrationBundle\Manager\FieldsChangesManager')
            ->disableOriginalConstructor()
            ->getMock();

        if (!empty($context['changeSet'])) {
            $fieldsChangesManager
                ->expects($this->once())
                ->method('setChanges')
                ->with(
                    $this->equalTo(
                        empty($context['data']) ? null : $context['data']
                    ),
                    $this->equalTo(
                        array_keys($context['changeSet'])
                    )
                );
        }

        $this->action->setFieldsChangesManager($fieldsChangesManager);
        $this->action->initialize($options);
        $this->action->execute(new ProcessData($context));
    }

    /**
     * @return array
     */
    public function executeDataProvider()
    {
        return [
            [
                [
                    'entity'    => new PropertyPath('entity'),
                    'changeSet' => new PropertyPath('changeSet'),
                ],
                [
                    'data'      => new \stdClass(),
                    'changeSet' => ['field' => ['old' => 1, 'new' => 2]],
                ]
            ],
            [
                [
                    'entity'    => new PropertyPath('entity'),
                    'changeSet' => new PropertyPath('changeSet'),
                ],
                ['changeSet' => []]
            ]
        ];
    }
}
