Content providers
=================

Overview
--------

**Oro platform** is hybrid application that supports JS navigation, but it still renders a lot on server side. Usually
 when user change current page, application reloads only content part, so there are parts that not required to be 
 rendered on sever side for each request. In order to allow developer including partial content in *hash navigation* response 
 **content providers** were introduced. 
 
Content provider implementation
----------------------------

If you want to implement content provider it's required to implement `\Oro\Bundle\UIBundle\ContentProvider\ContentProviderInterface`
and register your class as service with tag `oro_ui.content_provider`. 

Optional providers
------------------

By default all content providers are **enabled**, but if content that generated by your provider is optional you could 
pass `enabled: false` param to tag of provider's service definition. After that content will not be added to response, 
but optional providers might be enabled if pass their names through request parameter `_enableContentProviders`

Twig
----

When page loaded first time its content mostly renders by twig. In order to get content from content providers from 
twig template `oro_ui_content_provider_manager` global variable was added. It contains instance of `\Oro\Bundle\UIBundle\ContentProvider\ContentProviderManager`.

Example:
Getting array of all flash messages

```twig
{% set contentProviderContent = oro_ui_content_provider_manager.getContent(['flashMessages'])|first %}
```
